//////////////////////////////////////////////////////
// logoshow.c
//
//  Lee Juhyun
//
#include <panel.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>

int 	size_logo_lines;
int 	size_logo_cols;
int 	size_logo_y;
int 	size_logo_x;

extern 	int 	screen_size_cols;
extern 	int 	screen_size_lines;

extern 	WINDOW 	*w_logo;
extern 	PANEL	*p_logo;

int logo_show(void);
int init_w_logo(WINDOW **);
int show_w_logo(WINDOW *, char *, int );
int print_in_middle_logo(WINDOW *, int , int , int , char *, chtype);
int print_in_middle_logo_string(WINDOW *);

extern int write_log(char *);
extern int exit_program();

extern int stop_timer();
extern int start_timer();


int logo_show(void) {


	size_logo_lines	= 16;
	size_logo_cols	= 50;
	size_logo_y	= (screen_size_lines - 18)/2;
	size_logo_x	= (screen_size_cols - 50)/2;

	int c;
	
	stop_timer();

	if ((w_logo = newwin(size_logo_lines, size_logo_cols,
			size_logo_y, size_logo_x)) == NULL) {
		write_log("Error logo_show/newwin");
		exit_program();
	}
	
	if (show_w_logo(w_logo, "LLS v0.01", 3) == -1) {
		write_log("Error logo_show/show_w_logo");
		exit_program();
	}
	
	if (print_in_middle_logo_string(w_logo) == -1) {
		write_log("Error logo_show/print_in_middle_logo_string");
		exit_program();
	}


	if ((p_logo = new_panel(w_logo)) == NULL) {
		write_log("Error logo_show/new_panel");
		exit_program();
	}
	wrefresh(w_logo);
	refresh();


	if (keypad(w_logo, TRUE) == ERR) {
		write_log("Error logo_show");
		return -1;
	}

	
	getch();

	hide_panel(p_logo);
	
	update_panels();
	doupdate();

	refresh();

	start_timer();
	return 0;
}

int show_w_logo(WINDOW *win, char *label, int label_color) {
	int startx, starty, height, width;

	startx = size_logo_cols;
       	starty = 3;
	width = size_logo_cols;
	height = 3; 

	box(win, 0, 0);
	mvwaddch(win, 2, 0, ACS_LTEE);
	mvwhline(win, 2, 1, ACS_HLINE, width - 2);
	mvwaddch(win, 2, width - 1, ACS_RTEE);
	
	mvwaddch(win, size_logo_lines -7, 0, ACS_LTEE);
	mvwhline(win, size_logo_lines -7, 1, ACS_HLINE, width - 2);
	mvwaddch(win, size_logo_lines -7, width - 1, ACS_RTEE);

	if (print_in_middle_logo(win, 1, 0, width, label, COLOR_PAIR(label_color)) == -1) {
		write_log("Error show_w_logo/print_in_middle_logo");
		return -1;
	}

	return 0;

}

int print_in_middle_logo_string(WINDOW *win) {
	int width;
	char label[255];
	int result = 0;
	width = size_logo_cols;
	
	strcpy(label, "\"Welcome to LLS v1.0.0\"");
	result = print_in_middle_logo(win, 3, 0, width, label, COLOR_PAIR(1));
	strcpy(label, "\"License : GPL\"");
	result = print_in_middle_logo(win, 4, 0, width, label, COLOR_PAIR(1));
	strcpy(label, "dev by --");
	result = print_in_middle_logo(win, 5, 0, width, label, COLOR_PAIR(2));
	strcpy(label, "Lee Ju-hyun, xog2000@gmail.com");
	result = print_in_middle_logo(win, 6, 0, width, label, COLOR_PAIR(2));
	strcpy(label, "Lee Tae-Young, bluelove1105@hanmail.net");
	result = print_in_middle_logo(win, 7, 0, width, label, COLOR_PAIR(2));
	strcpy(label, "Lee Jae-Seung, emilio@nate.com");
	result =print_in_middle_logo(win, 8, 0, width, label, COLOR_PAIR(2));
	
	strcpy(label, "User Information");
	result = print_in_middle_logo(win, 10, 0, width, label, COLOR_PAIR(4));
	sprintf(label, "USER: %s@%s", getlogin(), getenv("HOSTNAME"));
	result = print_in_middle_logo(win, 11, 0, width, label, COLOR_PAIR(4));
	sprintf(label, "HOME: %s", getenv("HOME"));
	result = print_in_middle_logo(win, 12, 0, width, label, COLOR_PAIR(4));
	sprintf(label, "LANG: %s", getenv("LANG"));
	result = print_in_middle_logo(win, 13, 0, width, label, COLOR_PAIR(4));
	sprintf(label, "TERM: %s", getenv("TERM"));
	result = print_in_middle_logo(win, 14, 0, width, label, COLOR_PAIR(4));
	
	return result;
}

int print_in_middle_logo(WINDOW *win, int starty, int startx, int width, char *string, chtype color) {
	int length, x, y;
	float temp;

	if(win == NULL)
		win = stdscr;
	getyx(win, y, x);
	if(startx != 0)
		x = startx;
	if(starty != 0)
		y = starty;
	if(width == 0)
		width = 80;

	length = strlen(string);
	temp = (width - length)/2;
	x = startx + (int)temp;
	if (wattron(win, color) == ERR) {
		write_log("Error print_in_middle_logo/wattron");
		return -1;
	}
	mvwprintw(win, y, x, "%s", string);
	if (wattroff(win, color) == ERR) {
		write_log("Error print_in_middle_logo/wattroff");
		return -1;
	}
	refresh();

	return 0;
}

