//////////////////////////////////////////////////////
// titlebarkey.c
//
// Lee Juhyun
//
#include <menu.h>
#include "keylib.h"
#include "mainlib.h"
#include "varlib.h"

extern 	int 	screen_size_cols;
extern 	int 	screen_size_lines;
extern 	int 	index_menu;
extern 	menu_t 	*menudata;
extern	int	flag;

extern 	MENU 	*m_titlebar;
extern	MENU 	*m_submenu;
extern 	WINDOW 	*w_titlebar;
extern 	WINDOW 	*w_submenu;
extern 	WINDOW 	*w_fileinfo;
extern 	WINDOW	*w_filelist;

extern	void	show_w_filelist(char *, int);

void titlebar_key(int c) {
	
	int i;
	char temp[INS_MAX] = "";
	char label[80];

	switch(c) {
	case KEY_LEFT:
		menu_driver(m_titlebar, REQ_LEFT_ITEM);
		break;
	case KEY_RIGHT:
		menu_driver(m_titlebar, REQ_RIGHT_ITEM);
		break;
	case KEY_USER_SPACE:
		break;
	case KEY_USER_ENTER:
		index_menu = item_index(current_item(m_titlebar));
		set_menu_fore(m_titlebar, COLOR_PAIR(0) | A_REVERSE);
		set_menu_back(m_titlebar, COLOR_PAIR(0) );
		
		wrefresh(w_titlebar);
		break;
	case KEY_USER_TAB:
		flag = FI_MODE;
		index_menu = -1;

		sprintf(label, "                                      ");
		show_w_filelist(label, 1);
		wrefresh(w_filelist);

		sprintf(label, "Push TAB, U can use menu");
		show_w_filelist(label, 1);
		
		keypad(w_filelist, TRUE);
		
		set_menu_fore(m_titlebar, COLOR_PAIR(0) | A_REVERSE);
		set_menu_back(m_titlebar, COLOR_PAIR(0) );
		
		wrefresh(w_titlebar);
		
		wrefresh(w_filelist);
		refresh();

		break;
	}
}

