module hooker;

import std.c.windows.windows;
import std.Thread;
import dwt.dwt;

import win32DEF;
import logger;

class Hooker 
{
	private static int[int] NOCHARKEY;

	private static HHOOK hookHandle;
	private static int invenKeyCodes[6];
	private static int hotKeyCode;

	private static int enable = true;

	public static int preventWindowMode;
	public static int portalMode;
	public static int teamSelection;

	static this()
	{
		NOCHARKEY[DWT.ALT] = VK_MENU;
		NOCHARKEY[DWT.SHIFT] = VK_SHIFT;
		NOCHARKEY[DWT.CONTROL] = VK_CONTROL;

		/* Non-Numeric Keypad Keys */
		NOCHARKEY[DWT.ARROW_UP] = VK_UP;
		NOCHARKEY[DWT.ARROW_DOWN] = VK_DOWN;
		NOCHARKEY[DWT.ARROW_LEFT] = VK_LEFT;
		NOCHARKEY[DWT.ARROW_RIGHT] = VK_RIGHT;
		NOCHARKEY[DWT.PAGE_UP] = VK_PRIOR;
		NOCHARKEY[DWT.PAGE_DOWN] = VK_NEXT;
		NOCHARKEY[DWT.HOME] = VK_HOME;
		NOCHARKEY[DWT.END] = VK_END;
		NOCHARKEY[DWT.INSERT] = VK_INSERT;

		/* Virtual and Ascii Keys */
		NOCHARKEY[DWT.BS] = VK_BACK;
		NOCHARKEY[DWT.CR] = VK_RETURN;
		NOCHARKEY[DWT.DEL] = VK_DELETE;
		NOCHARKEY[DWT.ESC] = VK_ESCAPE;
		NOCHARKEY[DWT.LF] = VK_RETURN;
		NOCHARKEY[DWT.TAB] = VK_TAB;

		/* Functions Keys */
		NOCHARKEY[DWT.F1] = VK_F1;
		NOCHARKEY[DWT.F2] = VK_F2;
		NOCHARKEY[DWT.F3] = VK_F3;
		NOCHARKEY[DWT.F4] = VK_F4;
		NOCHARKEY[DWT.F5] = VK_F5;
		NOCHARKEY[DWT.F6] = VK_F6;
		NOCHARKEY[DWT.F7] = VK_F7;
		NOCHARKEY[DWT.F8] = VK_F8;
		NOCHARKEY[DWT.F9] = VK_F9;
		NOCHARKEY[DWT.F10] = VK_F10;
		NOCHARKEY[DWT.F11] = VK_F11;
		NOCHARKEY[DWT.F12] = VK_F12;
		NOCHARKEY[DWT.F13] = VK_F13;
		NOCHARKEY[DWT.F14] = VK_F14;
		NOCHARKEY[DWT.F15] = VK_F15;

		/* Numeric Keypad Keys */
		NOCHARKEY[DWT.KEYPAD_MULTIPLY] = VK_MULTIPLY;
		NOCHARKEY[DWT.KEYPAD_ADD] = VK_ADD;
		NOCHARKEY[DWT.KEYPAD_CR] = VK_RETURN;
		NOCHARKEY[DWT.KEYPAD_SUBTRACT] = VK_SUBTRACT;
		NOCHARKEY[DWT.KEYPAD_DECIMAL] = VK_DECIMAL;
		NOCHARKEY[DWT.KEYPAD_DIVIDE] = VK_DIVIDE;
		NOCHARKEY[DWT.KEYPAD_0] = VK_NUMPAD0;
		NOCHARKEY[DWT.KEYPAD_1] = VK_NUMPAD1;
		NOCHARKEY[DWT.KEYPAD_2] = VK_NUMPAD2;
		NOCHARKEY[DWT.KEYPAD_3] = VK_NUMPAD3;
		NOCHARKEY[DWT.KEYPAD_4] = VK_NUMPAD4;
		NOCHARKEY[DWT.KEYPAD_5] = VK_NUMPAD5;
		NOCHARKEY[DWT.KEYPAD_6] = VK_NUMPAD6;
		NOCHARKEY[DWT.KEYPAD_7] = VK_NUMPAD7;
		NOCHARKEY[DWT.KEYPAD_8] = VK_NUMPAD8;
		NOCHARKEY[DWT.KEYPAD_9] = VK_NUMPAD9;

		/* Other keys */
		NOCHARKEY[DWT.CAPS_LOCK] = VK_CAPITAL;
		NOCHARKEY[DWT.NUM_LOCK] = VK_NUMLOCK;
		NOCHARKEY[DWT.SCROLL_LOCK] = VK_SCROLL;
		NOCHARKEY[DWT.PAUSE] = VK_PAUSE;
		NOCHARKEY[DWT.BREAK] = VK_CANCEL;
		NOCHARKEY[DWT.PRINT_SCREEN] = VK_SNAPSHOT;
	}

	public static void setKey(int index, int value, int keyCode)
	{
		if( value == 0 ) {
			invenKeyCodes[index] = 0;
			int[] keys= NOCHARKEY.keys;
			for(int i=0; i<keys.length; i++){
				if(keys[i] == keyCode){
					invenKeyCodes[index] = NOCHARKEY[keys[i]];
					break;
				}
			}
		}else{
			invenKeyCodes[index] = cast(ushort) VkKeyScan ( value );
		}
	}

	public static void setHotKey(int value, int keyCode)
	{
		if ( value == 0 ) {
			hotKeyCode = 0;
			int[] keys= NOCHARKEY.keys;
			for(int i=0; i<keys.length; i++){
				if(keys[i] == keyCode){
					hotKeyCode = NOCHARKEY[keys[i]];
					break;
				}
			}
		}
		else hotKeyCode = cast(ushort) VkKeyScan (value);
	}

	public static void hook()
	{
		HINSTANCE hExe = GetModuleHandleA(null);
		if (!hExe) return;

		hookHandle = SetWindowsHookExA (WH_KEYBOARD_LL, &KeyHook, hExe, 0);
	}
	public static void unhook()
	{
		if ( hookHandle != null ) UnhookWindowsHookEx (hookHandle);
	}

	extern (Windows) static
	int KeyHook (int code, WPARAM wParam, LPARAM lParam)
	{
		if (code == HC_ACTION) {
			KBDLLHOOKSTRUCT *key = cast(KBDLLHOOKSTRUCT*)lParam;

			if ( key.vkCode == hotKeyCode){
				if( wParam == WM_SYSKEYDOWN || wParam == WM_KEYDOWN )
					enable = !enable;
				return 1;
			}
			
			if ( enable ) {
				if ( preventWindowMode && key.vkCode == VK_LWIN) 
					return 1;

				if ( portalMode && key.vkCode == VkKeyScan ('z') )
					(new Thread(&portalRun, null)).start();
				
				if ( inputKey(wParam, key.vkCode)  != 0)
					return 1;
			}
		}
		return CallNextHookEx (null, code, wParam, lParam);
	}

	private static int inputKey( LPARAM wParam, int key )
	{
		int isInvenKey;
		for( int i=0; i<invenKeyCodes.length; i++)
		{
			isInvenKey = invenKeyCodes[i] == key;
			if(isInvenKey) break;
		}
		if(!isInvenKey) return false;

		ushort tkey;
		if ( key == invenKeyCodes[0] )
		{
			tkey =  VK_NUMPAD7;
		}
		else if ( key == invenKeyCodes[1] )
		{
			tkey =  VK_NUMPAD8;
		}
		else if ( key == invenKeyCodes[2] )
		{
			tkey =  VK_NUMPAD4;
		}
		else if ( key == invenKeyCodes[3] )
		{
			tkey =  VK_NUMPAD5;
		}
		else if ( key == invenKeyCodes[4] )
		{
			tkey =  VK_NUMPAD1;
		}
		else if ( key == invenKeyCodes[5] )
		{
			tkey =  VK_NUMPAD2;
		}
//		KEYBDINPUT inputs;
//		inputs.dwFlags = wParam == WM_SYSKEYUP || wParam == WM_KEYUP ? KEYEVENTF_KEYUP : 0;
//		inputs.wVk = cast(ushort)tkey;
		INPUT pInputs;
		pInputs.type = INPUT_KEYBOARD;
		pInputs.ki.wVk = tkey;
		pInputs.ki.dwFlags = wParam == WM_SYSKEYUP || wParam == WM_KEYUP ? KEYEVENTF_KEYUP : 0;
//		RtlMoveMemory (&pInputs + 4, &inputs, KEYBDINPUT.sizeof);
		int result = SendInput (1, &pInputs, INPUT.sizeof+4);	// INPUT winapi size is 28 but 24 as D
		// debug
		/*
		alias std.string.toString str;
		Logger.writeI(
			"oKey:" ~ str(key) ~ 
			" tKey:" ~ str(tkey) ~ 
			" [event-number: "~ str(pInputs.ki.dwFlags) ~
			"] <error-number:" ~ str(GetLastError()) ~ ">"
			~ str(INPUT.sizeof) ~ " - " ~
			str(KEYBDINPUT.sizeof)
		);
		*/

		return result;
	}

	private static int portalRun(void *ptr)
	{

		LONG dx,dy;
		switch ( teamSelection )
		{
			case 1 :	// undead
				dx = 1800;
				dy = 52500;
				break;
			case 0 :	// sentinel
				dx = 11200;
				dy = 62100;
			default :
		}

		INPUT pInput;
		pInput.type = INPUT_MOUSE; 
		pInput.mi.dx = dx;
		pInput.mi.dy = dy;

		for (int i = 0; i < 10; i++) { // repeat click
			Sleep(55);		
			pInput.mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_MOVE;
			SendInput(1, &pInput, INPUT.sizeof+4);
			pInput.mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_LEFTDOWN;
			SendInput(1, &pInput, INPUT.sizeof+4);	
			pInput.mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_LEFTUP;
			SendInput(1, &pInput, INPUT.sizeof+4);
		}
		return 0;
	}

	static ~this()
	{
		unhook();
	}
}